using System;

namespace Implab
{
    public struct RejectedPromise<T> : IPromise<T> {
        readonly Exception m_reason;

        public Type ResultType => typeof(void);

        public bool IsResolved => true;

        public bool IsRejected => true;

        public bool IsFulfilled => false;

        public Exception RejectReason => m_reason;

        public RejectedPromise(Exception reason) {
            m_reason = reason;
        }

        public IPromise<T2> Cast<T2>() {
            return (IPromise<T2>)(IPromise<T>)this;
        }

        void IPromise.Join() {
            throw m_reason.Wrap();
        }

        void IPromise.Join(int timeout) {
            throw m_reason.Wrap();
        }

        public T Join() {
            throw m_reason.Wrap();
        }

        public T Join(int timeout) {
            throw m_reason.Wrap();
        }

        public void Then(IResolvable next) {
            next.Reject(m_reason);
        }

        public void Then(IResolvable<T> next) {
            next.Reject(m_reason);
        }
    }
}